<?php
// Mulakan sesi untuk menyemak pengguna yang log masuk
session_start();

// Import fail sambungan ke pangkalan data
require '../../intro/config.php';  // Pastikan fail ini mempunyai sambungan $conn

// Pastikan pengguna sudah log masuk
if (!isset($_SESSION['username'])) {
    header("Location: login.php"); // Arahkan ke halaman login jika tidak log masuk
    exit;
}

// Dapatkan nama pengguna dari sesi
$username = $_SESSION['username'];

// Pastikan markah dihantar melalui permintaan POST
if (isset($_POST['score'])) {
    $score = $_POST['score'];

    // Sediakan SQL untuk memasukkan atau mengemas kini skor
    $sql = "INSERT INTO awesome (username, score) VALUES (?, ?) 
            ON DUPLICATE KEY UPDATE score = VALUES(score)";

    // Sediakan dan jalankan pernyataan
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("si", $username, $score);
        
        if ($stmt->execute()) {
            echo "Skor berjaya dikemas kini.";
        } else {
            echo "Ralat: " . $stmt->error;
        }
        
        // Tutup pernyataan
        $stmt->close();
    } else {
        echo "Ralat penyediaan penyataan: " . $conn->error;
    }
}

// Tutup sambungan
$conn->close();
?>
